-- Hedgewars Campaign #01
-- Scripting Example

--missed
--illgetyou
--sndRegret     youllregretthat

--perfection

loadfile(GetDataPath() .. "Scripts/Locale.lua")()

---------------------------------------------------------------

local player = nil -- pointer for player gear
local enemy = nil	-- pointer for enemy gear

local returnControl = false -- give back control to player if he screws up
local hJumped = false
local lJumped = false

local GameOver = false
local mWon = false

local crate1 = nil
local hCrate = nil
local bazCrate = nil

local t1 = nil -- targets
local t2 = nil

local oCirc = nil -- objective circle

local bShotsFired = 0

local stage = 0 -- keeps track of mission/cinematic progress
local aTimer = 0 -- as above, but on a per mil second basis


local vGearTimer = 0
local vTarget = nil

function SwitchToHog(gear)

	if (CurrentHedgehog ~= nil) and (gear ~= nil) then

		SetState(CurrentHedgehog, 0)
		SetGearMessage(CurrentHedgehog, 0)
		SwitchHog(gear)

		if gear == player then
			SetInputMask(0xFFFFFFFF)
		elseif gear == enemy then
			SetInputMask(band(0xFFFFFFFF, bnot(gmAnimate+gmAttack+gmDown+gmHJump+gmLeft+gmLJump+gmPrecise+gmRight+gmSlot+gmSwitch+gmTimer+gmUp+gmWeapon)))
		end

	end

end

function TeleportGearXY(gear, destX, destY)

	AddVisualGear(GetX(gear)-5, GetY(gear)-5, vgtSmoke, 0, false)
	AddVisualGear(GetX(gear)+5, GetY(gear)+5, vgtSmoke, 0, false)
	AddVisualGear(GetX(gear)-5, GetY(gear)+5, vgtSmoke, 0, false)
	AddVisualGear(GetX(gear)+5, GetY(gear)-5, vgtSmoke, 0, false)
	SetGearPosition(gear, destX, destY)
	AddVisualGear(GetX(gear), GetY(gear), vgtBigExplosion, 0, false)

end

---------------------------------------------------
-- functions to allow you to follow virtual gears
---------------------------------------------------

function HandleFollowVGear()

	vGearTimer = vGearTimer + 1
	if vGearTimer == 2000 then
		vGearTimer = 0
		DeleteGear(vTarget)
		vTarget = nil
	end

end

function FollowVGear(gear)

	gX,gY,g4,g5,g6,g7,g8,g9,g10,g11 =  GetVisualGearValues(gear)
	vTarget = AddGear(gX, gY, gtTarget, 0, 0, 0, 0)
	SetTag(vTarget, 4)
	FollowGear(vTarget)

end

-------------------------------
-- normal game event handlers
-------------------------------

function onGameInit()

	-- Things we don't modify here will use their default values.
	Seed = 0 -- The base number for the random number generator
	GameFlags = gfInfAttack +gfSolidLand +gfDisableWind --+ gfResetWeps -- Game settings and rules
	TurnTime = 90000 -- The time the player has to move each round (in ms)
	CaseFreq = 0 -- The frequency of crate drops
	MinesNum = 0 -- The number of mines being placed
	MinesTime  = 3000
	Explosives = 0 -- The number of explosives being placed
	Delay = 10 -- The delay between each round
	Map = "Prison" -- The map to be played
	Theme = "Snow" -- The theme to be used

	AddTeam(loc("Cybernetic Empire"), 1175851, "Simple", "Island", "Robot","cm_binary")
	enemy = AddHog(loc("Unit 113"), 0, 100, "cyborg")

	AddTeam(loc("Pathetic Captives"), 14483456, "Simple", "Island", "Default", "Hedgewars")
	player = AddHog(loc("Prisoner 3207"), 0, 80, "NoHat") --NoHat

	SetGearPosition(player, 860, 738)
	SetGearPosition(enemy, 261, 632)

end


function onGameStart()

	-- crates crates and more crates
	crate1 = SpawnAmmoCrate(1335,555,amSkip)

	-- Add Mines
	AddGear(1180, 1887, gtMine, 0, 0, 0, 0)
	AddGear(1209, 1887, gtMine, 0, 0, 0, 0)
	AddGear(1236, 1887, gtMine, 0, 0, 0, 0)
	--AddGear(1325, 1593, gtSMine, 0, 0, 0, 0)

	t1 = AddGear(1939, 1864, gtTarget, 0, 0, 0, 0)
	t2 = AddGear(2023, 1792, gtTarget, 0, 0, 0, 0)


	TurnTimeLeft = 0

	FollowGear(enemy)

	--SetWind(0)						--2		-- -amBazooka
	ShowMission(loc("THE DARK TIDE"), loc("Chapter I"), "", -amSkip, 0)

	AddAmmo(enemy, amBazooka) -- new

	--ScriptSetInteger('Ready', 1);

end



function onNewTurn()

	TurnTimeLeft = -1

	if CurrentHedgehog == player then
		SetInputMask(0xFFFFFFFF)
	elseif CurrentHedgehog == enemy then
		SetInputMask(band(0xFFFFFFFF, bnot(gmAnimate+gmAttack+gmDown+gmHJump+gmLeft+gmLJump+gmPrecise+gmRight+gmSlot+gmSwitch+gmTimer+gmUp+gmWeapon)))
		AddAmmo(enemy, amBazooka)
	end

end


function onGameTick()


	if vTarget ~= nil then
		HandleFollowVGear()
	end

	--if CurrentHedgehog ~= nil then
	--	AddCaption(stage .. ": " .. GetX(CurrentHedgehog) .. ";" .. GetY(CurrentHedgehog))
	--end

	--if TurnTimeLeft > 2 then
	--	TurnTimeLeft = -1
	--end

	if (CurrentHedgehog == enemy) then
		--if the player hurts himself accidentally and loses his turn
		--return control to the player
		if returnControl == true then
			SetGearMessage(enemy, 0)
			aTimer = aTimer + 1
			if (aTimer == 2000) then
				HogSay(enemy, loc("{Sigh}"), SAY_THINK,2)
				--PlaySound(sndMissed, enemy) -- "Pathetic meatbag"
			elseif aTimer == 6000 then
				returnControl = false

				--TurnTimeLeft = 1
				SwitchToHog(player)

				aTimer = 0
			end
		end

		--remove this later (forcibly set game to some or other stage
		if stage == 0 then

			--just before obstacle course
			--stage = 96 --20
			--aTimer = 0
			--SetGearPosition(enemy,1020,642)

			--just after threats speech
			--stage = 28 --20
			--aTimer = 0
			--SetGearPosition(player,1050,1887)
			--SetGearPosition(enemy,902,1825)
			--TurnTimeLeft = 1

			--just after wep speech
			--stage = 32
			--aTimer = 0
			--SetGearPosition(player,1701,1879)
			--TurnTimeLeft = 1

		end


		if stage == 0 then
			SetGearMessage(enemy, gmRight)
			if GetX(CurrentHedgehog) == 474 then
				stage = 1
				aTimer = 0
			end

		elseif stage == 1 then

			SetGearMessage(enemy, 0)
			aTimer = aTimer + 1

			if aTimer == 2000 then
				HogSay(enemy, loc("Wake up, Prisoner 3205."), SAY_SAY,2)
			elseif aTimer == 9000 then
				HogSay(enemy, loc("Prisoner!!!"), SAY_SHOUT,2)
				--PlaySound(sndRegret, enemy) -- "Destroy all organics"
			elseif aTimer == 15000 then
				HogSay(enemy, loc("{Sigh}"), SAY_THINK,2)
				--PlaySound(sndIllGetYou, enemy) -- "Initiate retaliatory something"
			elseif aTimer == 20000 then
				HogSay(enemy, loc("HQ, Prisoner 3205 has ceased to function."), SAY_SAY,2)
			elseif aTimer == 27000 then
				PlaySound(sndMissed, enemy) -- "Pathetic meatbag"
				stage = 2
				aTimer = 0
			end


		elseif stage == 2 then
			SetGearMessage(enemy, gmLJump)
			if GetX(CurrentHedgehog) == 564 then
				SetGearMessage(enemy, 0)
				stage = 3
			end
		elseif stage == 3 then
			SetGearMessage(enemy, gmRight)
			if GetX(CurrentHedgehog) == 634 then
				SetGearMessage(enemy, 0)
				stage = 4
			end
		elseif stage == 4 then
			SetGearMessage(enemy, gmLJump)
			if GetX(CurrentHedgehog) == 725 then
				SetGearMessage(enemy, 0)
				stage = 5
			end
		elseif stage == 5 then
			SetGearMessage(enemy, gmRight)
			if GetX(CurrentHedgehog) == 812 then
				stage = 6
			end

		elseif stage == 6 then

			SetGearMessage(enemy, 0)
			aTimer = aTimer + 1

			if aTimer == 2000 then
				HogSay(enemy, loc("Prisoner 3207, are your legs still functional?"), SAY_SAY,2)
			elseif aTimer == 10000 then
				HogSay(enemy, loc("Prisoner!!!"), SAY_SHOUT,2)
			elseif aTimer == 13000 then
				stage = 7
				aTimer = 0
				--TurnTimeLeft = 1
				SwitchToHog(player)
				ShowMission(loc("Mission Objective"), loc("Use [left] or [right] to move around."), "", 1, 0)
			end
		-- Control passes over to player at this point


		elseif stage == 95 then

			aTimer = aTimer + 1

			SetGearMessage(enemy, 0)

			if aTimer == 4000 then
				SetGearMessage(enemy, gmLJump)
			end

			if GetX(CurrentHedgehog) == 894 then
				SetGearMessage(enemy, 0)
				stage = 96
				aTimer = 0
			end

		elseif stage == 96 then
			SetGearMessage(enemy, gmRight)

			if GetX(CurrentHedgehog) == 1020 then
				SetGearMessage(enemy, 0)
				aTimer = aTimer + 1
				if aTimer == 1000 then
					HogSay(enemy, loc("Activating teleporter, now..."), SAY_SAY,2)
				elseif aTimer == 6000 then
					stage = 14
					TeleportGearXY(player,473,923)
					TurnTimeLeft = 1
					--SwitchToHog(player)
					-- control passes back to player at this point
				end
			end

		elseif stage == 20 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, 0)

			if aTimer == 500 then
				SetInputMask(0xFFFFFFFF)
				ParseCommand("setweap " .. string.char(amBazooka))
				SetInputMask(band(0xFFFFFFFF, bnot(gmAnimate+gmAttack+gmDown+gmHJump+gmLeft+gmLJump+gmPrecise+gmRight+gmSlot+gmSwitch+gmTimer+gmUp+gmWeapon)))
			elseif aTimer == 1500 then
				stage = 21
				aTimer = 0
			end

		elseif stage == 21 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, gmUp)

			if aTimer == 200 then
				aTimer = 0
				stage = 22
			end

		elseif stage == 22 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, gmAttack)

			if aTimer == 1000 then
				stage = 23
			end

		elseif stage == 23 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, 0)

			if aTimer == 6000 then
				FollowGear(enemy)
				HogSay(enemy,loc("That's for taking so long."),SAY_SAY,2)
			elseif aTimer == 11000 then
				HogSay(enemy,loc("If you want to remain functional, you'll be quicker in getting back to the teleporter."),SAY_SAY,2)
			elseif aTimer == 20000 then
				stage = 24
				aTimer = 0
				--TurnTimeLeft = 1
				SwitchToHog(player)
				ShowMission(loc("Mission Objective:"), loc("Return to the teleporter."), "", 1, 0)

			end

		elseif stage == 25 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, 0)
			if aTimer == 500 then
				ParseCommand("setweap " .. string.char(amNothing))
			elseif aTimer == 3000 then

				TeleportGearXY(player,867,1936)
				TeleportGearXY(enemy,903,1825)
				--SetGearPosition(player,867,1936)
				--SetGearPosition(enemy,903,1825)

			elseif aTimer == 3500 then
				--TurnTimeLeft = 1
				SwitchToHog(player)
				aTimer = 0
				stage = 26
				--SWAP CONTROL AFTER TELEPORT
			end

		elseif stage == 27 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, 0)

			if aTimer == 3500 then
				HogSay(enemy,loc("In our tests, you may encounter certain enviromental hazards."),SAY_SAY,2)
			elseif aTimer == 10000 then
				HogSay(enemy,loc("Small things like pit traps..."),SAY_SAY,2)
			elseif aTimer == 14000 then
				HogSay(enemy,loc("drowning pools..."),SAY_SAY,2)
			elseif aTimer == 17000 then
				HogSay(enemy,loc("high falls..."),SAY_SAY,2)
			elseif aTimer == 20000 then
				HogSay(enemy,loc("anti-personnel mines..."),SAY_SAY,2)
			elseif aTimer == 23000 then
				HogSay(enemy,loc("and so on."),SAY_SAY,2)
			elseif aTimer == 28000 then
				HogSay(enemy,loc("Of course, none of them are THAT dangerous..."),SAY_SAY,2)
			elseif aTimer == 33000 then
				HogSay(enemy,loc("But for a weak, organic, hog like yourself, they could easily prove fatal."),SAY_SAY,2)
			elseif aTimer == 40000 then
				HogSay(enemy,":D",SAY_THINK,2)
			elseif aTimer == 42500 then
				HogSay(enemy,loc("I would hate for something to happen to you, so watch your step."),SAY_SAY,2)
			elseif aTimer == 47000 then
				--TurnTimeLeft = 1
				SwitchToHog(player)
				aTimer = 0
				stage = 28
				--SWAP CONTROL BACK TO PLAYER AFTER SPEECH
			end

		elseif stage == 29 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, 0)

			if aTimer == 500 then
				HogSay(enemy,loc("Hmm. Looks like you survived."),SAY_SAY,2)
			elseif aTimer == 4000 then
				HogSay(enemy,loc("Here, fix yourself up."),SAY_SAY,2)
				hCrate = SpawnHealthCrate(1782,1710) --1782,1849)
			elseif aTimer == 7000 then
				ShowMission(loc("Note:"), loc("Health crates will heal you when damaged."), "", 2, 0)
				--TurnTimeLeft = 1
				SwitchToHog(player)
				aTimer = 0
				stage = 30
			end
		elseif stage == 31 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, 0)

			if aTimer == 500 then
				HogSay(enemy,loc("Occasionally, you may be required to destroy a target."),SAY_SAY,2)
			elseif aTimer == 4000 then
				HogSay(enemy,loc("Let's see how a pathetic hog like you handles a weapon."),SAY_SAY,2)
			elseif aTimer == 8500 then
				HogSay(enemy,loc("There are two targets in this room. Destroy them both."),SAY_SAY,2)
			elseif aTimer == 13000 then
				HogSay(enemy,loc("I will be watching you from my observational study."),SAY_SAY,2)
			elseif aTimer == 17000 then
				HogSay(enemy,loc("See you soon..."),SAY_SAY,2)
			elseif aTimer == 20000 then
				TeleportGearXY(enemy,674,136)
			elseif aTimer == 22000 then
				stage = 32
				--TurnTimeLeft = 1
				SwitchToHog(player)
				aTimer = 0

				--bazCrate = SpawnAmmoCrate(2127,1715,amBazooka)
				--ShowMission(loc("Mission Objective:"), loc("Pick up the weapons crate."), "", -amBazooka, 0)

--[[elseif aTimer == 4000 then
				HogSay(enemy,loc("Out of ammo, eh?"),SAY_SAY,2)]]

			--ShowMission(loc("Note:"), loc("Your captor will not activate the teleporter while you still have ammo."), "", -amBazooka, 0)

			--ShowMission(loc("Objective:"), loc("Select 'Bazooka' from the weapons menu."), loc("Use [right click] to open the weapons menu"), -amBazooka, 0)

			end
		elseif stage == 36 then
			aTimer = aTimer + 1
			SetGearMessage(enemy, 0)

			if aTimer == 500 then
				HogSay(enemy,loc("Interesting, MOST interesting..."),SAY_SAY,2)
			elseif aTimer == 2000 then
				HogSay(enemy,loc("You may actually live to see the end of the week."),SAY_SAY,2)
			elseif aTimer == 6000 then
				HogSay(enemy,loc("We're going to have a lot of fun together, Prisoner 3207."),SAY_SAY,2)
			elseif aTimer == 10000 then
				HogSay(enemy,loc("Look forward to it..."),SAY_SAY,2)
			elseif aTimer == 13000 then
				mWon = true
				--SetHealth(player, 0)
				stage = 37
				--TurnTimeLeft = 1
				SwitchToHog(player)
				ShowMission(loc("MISSION COMPLETE"), loc("Congratulations!"), "", 0, 0)
				ParseCommand("teamgone Cybernetic Empire")
			end


		end

	end


-------------------------------
-------------------------------
-------------------------------
-------------------------------


	if (CurrentHedgehog == player) then
		aTimer = aTimer + 1

		if stage == 7 then

			if GetX(CurrentHedgehog) ~= 860 then
				stage = 8
				aTimer = 0
			end

		elseif stage == 8 then

			if aTimer == 2000 then
				HogSay(enemy, loc("Excellent."), SAY_SAY,2)
			elseif aTimer == 6000 then
				HogSay(enemy, loc("I see you can still walk."), SAY_SAY,2)
			elseif aTimer == 10000 then
				HogSay(enemy, loc("But can you jump?"), SAY_SAY,2)
			elseif aTimer == 14000 then
				ShowMission(loc("Mission Objective"), loc("Press [Enter] to do a long jump."), "", 1, 0)
				stage = 9
				lJumped = false
			end

		elseif (stage == 9) and (lJumped == true) then
			stage = 10
			aTimer = 0

		elseif (stage == 10) then

			if aTimer == 2000 then
				HogSay(enemy, loc("Good."), SAY_SAY,2)
			elseif aTimer == 6000 then
				HogSay(enemy, loc("Try a high jump."), SAY_SAY,2)
			elseif aTimer == 10000 then
				ShowMission(loc("Mission Objective"), loc("Press [Backspace] to do a high jump."), "", 1, 0)
				stage = 11
				hJumped = false
			end

		elseif (stage == 11) and (hJumped == true) then

			stage = 12
			aTimer = 0

		elseif (stage == 12) then

			if aTimer == 2000 then
				HogSay(enemy, loc("Not bad, meatbag"), SAY_SAY,2)
			elseif aTimer == 7000 then
				HogSay(enemy, loc("Yes, I think you'll do nicely..."), SAY_SAY,2)
			elseif aTimer == 13000 then
				HogSay(enemy, loc("Get on your teleporter and wait."), SAY_SAY,2)
			elseif aTimer == 18000 then
				ShowMission(loc("Mission Objective"), loc("Wait on the raised platform to the left of your cell."), "", 1, 0)
				stage = 13
				aTimer = 0
			end

		elseif (stage == 13) then

			if GetX(CurrentHedgehog) > 830 then
				aTimer = 0
			end

			if aTimer == 3000 then
				HogSay(enemy, loc("Let's get started."), SAY_SAY,2)
				--TurnTimeLeft = 1
				SwitchToHog(enemy)
				stage = 95
				aTimer = 0
				-- control changes here
			end

		elseif (stage == 14) and (GetX(CurrentHedgehog) > 620) then
			ShowMission(loc("Note:"), loc("You can perform a backwards jump by pressing [backspace] twice rapidly."), "", 2, 0)
			stage = 15

		elseif (stage == 15) and (GetX(CurrentHedgehog) > 1072) then
			HogSay(enemy, loc("Okay, meatbag. Try get that crate up there."), SAY_SAY,2)
			stage = 16
		elseif (stage == 16) and (GetX(CurrentHedgehog) > 1770) then
			ShowMission(loc("Hint:"), loc("Try tapping [backspace] twice, now."), "", 2, 0)
			stage = 17

		--time to get back to the teleporter!
		elseif (stage == 241) and (GetX(CurrentHedgehog) < 479) then
			stage = 25
			SwitchToHog(enemy)
			--TurnTimeLeft = 1
			aTimer = 0
			SetVisualGearValues(oCirc, 473,923, 0, 0, 1, 10, 0, 0, 0, GetClanColor(1))	 -- remove teleporter circ
		elseif (stage == 24) then
				oCirc = AddVisualGear(473,923,vgtCircle,0,true)
				SetVisualGearValues(oCirc, 473,923, 10, 200, 1, 10, 0, 200, 5, GetClanColor(1))
				FollowVGear(oCirc)
				stage = 241
		elseif (stage == 26) and (GetX(CurrentHedgehog) > 960) then
			stage = 27
			--TurnTimeLeft = 1
			SwitchToHog(enemy)
			aTimer = 3000
		elseif (stage == 28) and (GetX(CurrentHedgehog) > 1720) then
			stage = 29
			--TurnTimeLeft = 1
			SwitchToHog(enemy)
			aTimer = 0
			TeleportGearXY(enemy,1721,1742)
		elseif (stage == 32) then
			stage = 33
			bazCrate = SpawnAmmoCrate(2127,1715,amBazooka)
			ShowMission(loc("Mission Objective:"), loc("Pick up the weapons crate."), "", 1, 0)
		elseif (stage == 35) and (GetX(CurrentHedgehog) > 2120) then
			stage = 36
			aTimer = 0
			--TurnTimeLeft = 1
			SwitchToHog(enemy)
			TeleportGearXY(player,812,777)
			TeleportGearXY(enemy,812,642)
		elseif (stage == 37) then

		end

	end







	--[[if (TotalRounds == 2) and (GameOver == false) then -- just in case
		SetHealth(player, 0)
		GameOver = true
	end

	if (TurnTimeLeft == 1) and (CurrentHedgehog == player) then
		--ShowMission(loc(caption), loc(subcaption), loc(timeout), -amSkip, 0);
		SetHealth(player, 0)
		GameOver = true
	end]]

end


function onAmmoStoreInit()
	SetAmmo(amShotgun, 0, 0, 0, 1)
	SetAmmo(amBazooka, 0, 0, 0, 4)
	SetAmmo(amBee, 0, 0, 0, 1)
	SetAmmo(amBlowTorch, 0, 0, 0, 1)
	SetAmmo(amGirder, 0, 0, 0, 1)
	SetAmmo(amParachute, 0, 0, 0, 1)
	SetAmmo(amPickHammer, 0, 0, 0, 1)
	SetAmmo(amJetpack, 0, 0, 0, 1)
	SetAmmo(amLaserSight, 0, 0, 0, 1)
	SetAmmo(amTeleport, 9, 0, 0, 0)
	SetAmmo(amSkip, 9, 0, 0, 0)
end

function onHJump()
	hJumped = true
	--AddCaption('h jump')
end
function onLJump()
	lJumped = true
	--AddCaption('l jump')
end

function onSetWeapon()
	if stage == 33 then
		ShowMission(loc("Bazooka selected!"), loc("Use [up] and [down] to aim."), "Hold down [space bar] to fire.", -amBazooka, 0)
		stage = 34
	end
end

function onGearAdd(gear)
-- not needed today
end

-- change capitalisation later
function onGearDamage(gear, damage)

	-- should we heal the player for any damage he takes?
--	if gear == player then
--		SetHealth(player, GetHealth(player) + damage)
--	end

	-- return control to player if he accidentally hurts himself
	-- see onGameTick()
	if (gear == player) and (stage ~= 23) then
		returnControl = true
		aTimer = 0
	end

end

function onGearDelete(gear)

	if gear == crate1 then
		HogSay(enemy, loc("Hmm..."), SAY_SAY,2)
		TurnTimeLeft = 1
		--SwitchToHog(enemy)
		aTimer = 0
		stage = 20
	end

	if gear == hCrate then
		--TurnTimeLeft = 1
		SwitchToHog(enemy)
		aTimer = 0 --0
		stage = 31
	end

	if gear == bazCrate then
		ShowMission(loc("OBJECTIVE COMPLETE"), loc("You've found a bazooka!"), loc("Use [right click] to open the weapons menu"), -amBazooka, 0)
	end

	if (gear == t1) or (gear == t2) then
		if gear == t1 then
			t1 = nil
			AddCaption(loc("Target destroyed!"))
		elseif gear == t2 then
			t2 = nil
			AddCaption(loc("Target destroyed!"))
		end

		if (t1 == nil) and (t2 == nil) then
			ShowMission(loc("OBJECTIVE COMPLETE"), loc("Wait on the teleporter"), "", 4, 0)
			stage = 35
		end

	end

	--[[if GetGearType(gear) == gtShell then
		--ShowMission(loc("shell deleted:"), loc("You've run out of ammo."), "", -amBazooka, 0)
		bShotsFired = bShotsFired + 1
		if bShotsFired == 2 then
			if (t1 == nil) and (t2 == nil) then
				ShowMission(loc("OBJECTIVE COMPLETE"), loc("Wait on the teleporter"), "", -amBazooka, 0)
			else
				ShowMission(loc("Note:"), loc("You've run out of ammo."), "", -amBazooka, 0)
			end
		end

	end]]

	if (gear == enemy) and (GameOver == false) then
		--ShowMission(loc("SAY WHAT"), loc("HOW DID YOU DO THAT?"), loc("YOU CRAZY FOOL."), 0, 0);
	elseif (gear == player) and (mWon == false) then
		FollowGear(enemy)
		HogSay(enemy, loc("Pathetic!"), SAY_SAY,2)
		ShowMission(loc("MISSION FAILED"), loc("Prisoner 3207 must survive."), "", -amSkip, 0)
		GameOver = true
		PlaySound(sndMissed, enemy) -- "Pathetic meatbag"
	end

end
